<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FireTruck extends Model 
{

    protected $table = 'fire_trucks';
    public $timestamps = true;
    protected $fillable = array('numberplate', 'fire_type_id');
    protected $visible = array('numberplate', 'fire_type_id');

    public function fires()
    {
        return $this->belongsToMany('App\Models\Fire');
    }

    public function fireStation()
    {
        return $this->belongsTo('App\Models\FireStation');
    }

    public function fireTruckType()
    {
        return $this->belongsTo('App\Models\FireTruckTypes');
    }

}